import {useEffect, useState} from "react";
import {useStoreState,useStoreActions} from "easy-peasy";
import {prop} from "ramda";

export default () => {
    const {previousTranslation} = useStoreState(prop('generalData'));
    const {setPreviousTranslation} = useStoreActions(prop('generalData'));

    const hidePreviousTranslationNotification = () => {
        setTimeout(() => {
            const url = new URL(window.location.href);
            url.searchParams.delete('previousTranslation')
            window.history.pushState({}, document.title, url.toString());
            setPreviousTranslation(false)
        }, 2000);
    }

    useEffect(() => {
            if (previousTranslation === 'accepted' || previousTranslation === 'published') {
                hidePreviousTranslationNotification();
            }
        }, []
    );

    return [previousTranslation];
};

