import CheckJobs from './CheckJobs';

export default class ServiceInstruction {
	/**
	 *
	 * @param {CheckJobs} checkJobs
	 * @param container
	 * @param ajaxUrl
	 */
	constructor(checkJobs, container, ajaxUrl) {
		this.checkJobs = checkJobs;
		this.container = container;
		this.ajaxUrl = ajaxUrl;
	}

	async load() {
		const hasJobs = await this.checkJobs.hasFinishedRemoteJobs();

		if ( hasJobs ) {
			const dismissButtons = this.container.querySelectorAll( '.js-ts-instruction-dismiss' );
			[...dismissButtons].map( ( dismissButton ) => {
					dismissButton.style.display = 'inline-block';
					dismissButton.addEventListener( 'click', () => {
						this.dismiss();
					} );
				}
			);
			const stuff            = this.container.querySelector( '#this-stuff-is-important' );
			stuff.style.display    = 'none';
			const checkbox         = this.container.querySelector( '#checkbox-my-test-translation-went-fine' );
			checkbox.disabled      = false;
			checkbox.style.display = 'inline-block';
			const fine             = this.container.querySelector( '#my-test-translation-went-fine' );
			fine.style.display     = 'inline-block';
			checkbox.addEventListener( 'click', () => {
				const button    = this.container.querySelector( '#dismiss-instruction' );
				button.disabled = false;
			} );
		}
	}

	async dismiss() {
		try {
			const result = await fetch(this.ajaxUrl, {
				method: 'POST',
				headers: {
					'Content-Type': 'application/x-www-form-urlencoded; charset=utf-8'
				},
				body: `action=translation_service_instruction_dismiss`,
				credentials: 'same-origin'
			});

			if (!result.ok) {
				throw new Error(result.statusText);
			}

			this.container.remove();
		} catch (e) {
			console.log(e);
		}
	}
}