import React, {useState} from 'react';
import {useStoreActions, useStoreState} from 'easy-peasy';
import Modal from 'antd/lib/modal';
import {__, sprintf} from 'wpml-common-js-source/src/i18n';
import {partial, pipe, prop} from 'ramda';
import Connect from "./Connect";
import Button from "antd/lib/button";
import Col from "antd/lib/col";
import Row from "antd/lib/row";
import notification from 'antd/lib/notification';

export default () => {
    const authModalOpen = useStoreState(prop('authModalOpen'));
    const selectedService = useStoreState(prop('selectedService'));
    const unselectService = useStoreActions(prop('unselectService'));
    const activateService = useStoreActions(prop('activateService'));
    const setAuthModalOpen = useStoreActions(prop('setAuthModalOpen'));

    return selectedService ? (
        <Modal
            className="wpml-translation-services-authorize"
            title={sprintf(__('Connect this site to your %s account', 'sitepress'), selectedService.name)}
            visible={authModalOpen}
            width={1024}
            onCancel={() => setAuthModalOpen(false)}
            footer={<Footer useDifferent={unselectService} authenticate={activateService}/>}
        >
            <Connect service={selectedService}/>
        </Modal>
    ) : null;
};

const Footer = ({useDifferent, authenticate}) => {
    const apiToken = useStoreState(prop('apiToken'));
    const selectedService = useStoreState(prop('selectedService'));
    const [inProgress, setInProgress] = useState(false);

    const onClick = async () => {
        setInProgress(true);
	    notification.destroy();

	    const formatError = error => error.includes('Details: |') ? error.split('Details: |')[0] : error;

        const onFailure = pipe(
            err =>  notification.error({message: __('Error', 'wpml-translation-management'), description: formatError(err), top: 50}),
            partial(setInProgress, [false])
        );
        const onSuccess = () => window.location.reload();

        const result = await authenticate({service: selectedService, apiToken: apiToken});
        result.bimap(onFailure, onSuccess);
    };

    return <Row>
        <Col span={12} align="left">
            <Button key="back" onClick={useDifferent}>
                {__('« Use a different Translation Service', 'sitepress')}
            </Button>
        </Col>
        <Col span={12} align="right">
            <Button key="authenticate" type="primary" onClick={onClick} disabled={!apiToken} loading={inProgress}>
                {__('Authenticate', 'sitepress')}
            </Button>
        </Col>
    </Row>
};
