import React                      from 'react';
import Collapse                   from 'antd/lib/collapse';
import 'antd/lib/collapse/style/index.css';
import ServiceList                from "./ServicesList";
import {useStoreState}            from "easy-peasy";
import {identity}                 from "ramda";
import {__}                       from 'wpml-common-js-source/src/i18n';
import {createInterpolateElement} from '@wordpress/element';
import "../style/index.scss";

const {Panel} = Collapse;


const LinkToSettingsPage = () => {
    const {settingsUrl} = useStoreState(identity);
    return <a href={settingsUrl}>{__('Settings', 'wpml-translation-management')}</a>
}


export default () => {
    const {sections, show} = useStoreState(identity);

    if (show) {
        return <Collapse defaultActiveKey={[0]}>
            {
                sections.map(({header, showPopularity, pagination}, sectionIndex) => (
                                 <Panel key={sectionIndex} header={header}>
                                     <ServiceList sectionIndex={sectionIndex} showPopularity={showPopularity}
                                                  pagination={pagination}/>
                                 </Panel>
                             ),
                )
            }
        </Collapse>
    }

    return <NotAvailableMessage/>
};

const NotAvailableMessage = () => {
    const message = createInterpolateElement(
        __("It’s not currently possible to connect a translation service when WPML is set to translate your site’s content automatically. To use a translation service, please change your translation mode on the <LinkToSettingsPage /> page.", 'wpml-translation-management'),
        {
            LinkToSettingsPage: <LinkToSettingsPage/>,
        },
    )

    return <div className={'wpml-translation-service-not-available'}>
        <p>{message}</p>
    </div>
};
