<?php

namespace WPML;

use WPML\FP\Fns;
use WPML\FP\Lst;
use WPML\FP\Obj;
use WPML\FP\Relation;
use WPML\Setup\Option;

class Plugins {
	const WPML_SUBSCRIPTION_TYPE_BLOG = 6718;
	const AFTER_INSTALLER = 999;

	public static function loadCoreFirst() {
		$plugins = get_option( 'active_plugins' );

		$isSitePress = function( $value ) {
			return $value === WPML_PLUGIN_BASENAME;
		};

		$newOrder = wpml_collect( $plugins )
			->prioritize( $isSitePress )
			->values()
			->toArray();

		if ( $newOrder !== $plugins ) {
			update_option( 'active_plugins', $newOrder );
		}
	}

	public static function isTMAllowed() {
		$isTMAllowed = true;

		if ( function_exists( 'OTGS_Installer' ) ) {
			$subscriptionType = OTGS_Installer()->get_subscription( 'wpml' )->get_type();
			if ( $subscriptionType && $subscriptionType === self::WPML_SUBSCRIPTION_TYPE_BLOG ) {
				$isTMAllowed = false;
			}
		}

		return $isTMAllowed;
	}

	public static function updateTMAllowedOption() {
		Option::setTMAllowed( self::isTMAllowed() );
	}

	/**
	 * @param bool $isSetupComplete
	 */
	public static function loadEmbeddedTM( $isSetupComplete) {
		$plugins = get_option( 'active_plugins' );
		$tmSlug  = 'wpml-translation-management/plugin.php';

		self::stopPluginActivation( $tmSlug );

		if ( Lst::includes( $tmSlug, $plugins ) ) {
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
			require_once ABSPATH . 'wp-includes/pluggable.php';

			deactivate_plugins( $tmSlug );
			if ( ! ( defined( 'WP_CLI' ) && WP_CLI ) && wp_redirect( $_SERVER['REQUEST_URI'], 302, 'WPML' ) ) {
				exit;
			}
		} else {
			add_action( "after_plugin_row_$tmSlug", [ self::class, 'showEmbeddedTMNotice' ] );
		    add_action( "otgs_installer_clean_plugins_update_cache", [ self::class, 'updateTMAllowedOption' ] );

			$isTMAllowed = Option::isTMAllowed();
			if( $isTMAllowed === null ) {
				add_action( 'after_setup_theme', [ self::class, 'updateTMAllowedOption' ], self::AFTER_INSTALLER );
			}
			if ( ! $isSetupComplete || $isTMAllowed ) {
				require_once WPML_PLUGIN_PATH . '/vendor/wpml/tm/plugin.php';
			}
		}
	}

	private static function stopPluginActivation( $pluginSlug ) {
		if ( Relation::propEq( 'action', 'activate', $_GET ) && Relation::propEq( 'plugin', $pluginSlug, $_GET ) ) {
			unset( $_GET['plugin'], $_GET['action'] );
		}

		if (
			Relation::propEq( 'action', 'activate-selected', $_POST )
			&& Lst::includes( $pluginSlug, Obj::propOr( [], 'checked', $_POST ) )
		) {
			$_POST['checked'] = Fns::reject( Relation::equals( $pluginSlug ), $_POST['checked'] );
		}
	}

	public static function showEmbeddedTMNotice() {
		$wpListTable = _get_list_table( 'WP_Plugins_List_Table' );
		?>

		<tr class="plugin-update-tr">
			<td colspan="<?php echo $wpListTable->get_column_count(); ?>" class="plugin-update colspanchange">
				<div class="update-message inline notice notice-error notice-alt">
					<p>
						<?php
						echo _e(
							'Since WPML version 4.5.0, the Translation Management plugin is part of WPML core. Please deactivate this plugin. You can also delete it from your plugins folder.',
							'sitepress'
						);
						$readMoreLink = '#'; //@TODO: Put a proper WPML 4.5.0 announcement link here
						?>
						<a href="<?php echo $readMoreLink; ?>" target="_blank" class="wpml-external-link">
							<?php _e( 'Read more', 'sitepress' ); ?>
						</a>
					</p>
				</div>
		</tr>
		<?php
	}
}
