<?php

namespace OTGS\Installer\AdminNotices\Notices;

use OTGS\Installer\AdminNotices\TMConfig;
use OTGS\Installer\AdminNotices\ToolsetConfig;
use OTGS\Installer\AdminNotices\WPMLConfig;
use OTGS\Installer\Collection;
use function OTGS\Installer\FP\partial;

class SiteKey {
	const SITE_URL_CHANGED = 'site-url-changed';

	public static function addHooks(\WP_Installer $installer ) {
		add_filter( 'otgs_installer_admin_notices_config', self::class . '::config' );
		add_filter( 'otgs_installer_admin_notices_texts', self::class . '::texts' );
		add_filter(
			'otgs_installer_admin_notices',
			partial( self::class . '::getCurrentNotices', $installer )
		);
	}

	/**
	 * @param \WP_Installer $installer
	 * @param array $initialNotices
	 *
	 * @return array
	 */
	public static function getCurrentNotices( \WP_Installer $installer, array $initialNotices ) {
		$config = $installer->get_site_key_nags_config();

		$noticeTypes = [
			SiteKey::SITE_URL_CHANGED => [ SiteKey::class, 'shouldShowSiteUrlChangedNotice' ],
		];

		return collection::of( $noticeTypes )
		                 ->entities()
		                 ->reduce(
			                 Notice::addNoticesForType( $installer, $config ),
			                 Collection::of( $initialNotices )
		                 )
		                 ->get();

	}

	public static function shouldShowSiteUrlChangedNotice( \WP_Installer $installer, array $nag ) {
		return $installer->checkSiteUrlChanged( $nag['repository_id'] );
	}

	public static function config( array $initialConfig ) {
		return self::pages( self::screens( $initialConfig ) );
	}

	public static function pages( array $initialPages ) {
		$wpmlPages = [ 'pages' => array_merge( WPMLConfig::pages(), TMConfig::pages() ) ];
		$toolsetPages = [ 'pages' => ToolsetConfig::pages() ];

		return array_merge_recursive( $initialPages, [
			'repo' => [
				'wpml'    => [
					SiteKey::SITE_URL_CHANGED => $wpmlPages,
				],
				'toolset' => [
					SiteKey::SITE_URL_CHANGED => $toolsetPages,
				],
			],
		] );
	}

	public static function screens( array $screens ) {
		$config = [
			SiteKey::SITE_URL_CHANGED => [ 'screens' => [ 'plugins', 'plugin-install' ] ],
		];

		return array_merge_recursive( $screens, [
			'repo' => [
				'wpml'    => $config,
				'toolset' => $config,
			],
		] );
	}

	public static function texts( array $initialTexts ) {
		return array_merge_recursive( $initialTexts, [
			'repo' => [
				'wpml'    => [
					SiteKey::SITE_URL_CHANGED => WPMLTexts::class . '::siteUrlChanged',
				],
				'toolset' => [
					SiteKey::SITE_URL_CHANGED => ToolsetTexts::class . '::siteUrlChanged',
				],
			],
		] );
	}
}
