<?php

namespace OTGS\Installer\SiteKey;

class SiteKeyHooks {
	public static function addHooks() {
		add_action( 'wp_ajax_installer_site_key_changed_action', self::class . '::handleSiteKeyChanged' );
	}

	public static function handleSiteKeyChanged() {
		$repositoryId = isset( $_POST['repositoryId'] ) && $_POST['repositoryId']
			? sanitize_text_field( $_POST['repositoryId'] ) : null;
		$state        = isset( $_POST['state'] ) && $_POST['state']
			? sanitize_text_field( $_POST['state'] ) : null;

		if ( array_key_exists( 'nonce', $_POST )
		     && wp_verify_nonce( $_POST['nonce'], 'site_key_changed_action_nonce' ) ) {
			SiteKeyUrlStorage::updateState( $repositoryId, $state );

			if (
				in_array( $state, [ SiteKeyUrlStorage::STATE_SITE_MOVED, SiteKeyUrlStorage::STATE_SITE_COPIED ] )
			) {
				do_action( 'otgs_handle_installer_site_url_detection', $state );
			}
		}
	}
}
