#!/usr/bin/env bash

cwd=$(pwd)

# Install only if CodeMirror does not exists or is empty
if  [[ ! -d libraries/CodeMirror ]] || [[ ! "$(ls -A libraries/CodeMirror)" ]]; then
    npm config set registry http://registry.npmjs.org/

    echo "Installing CodeMirror..."

    rm -Rf ./libraries/CodeMirror
    git clone -q https://github.com/codemirror/CodeMirror.git ./libraries/CodeMirror
    cd ./libraries/CodeMirror
    git checkout -q tags/5.31.0
    rm -rf .git
    npm install

    cd mode
    find . -maxdepth 1 ! -name '.' ! -regex '.*/xml$' -exec rm -r {} +
    rm xml/index.html

    cd ${cwd}
fi

# Install only if vkBeautify does not exists or is empty
if  [[ ! -d libraries/vkBeautify ]] || [[ ! "$(ls -A libraries/vkBeautify)" ]]; then
    cd ${cwd}

    echo "Installing vkBeautify..."

    rm -Rf ./libraries/vkBeautify
    git clone -q https://github.com/nsoms/vkBeautify.git ./libraries/vkBeautify
    cd ./libraries/vkBeautify
    rm -rf .git

    cd ${cwd}
fi
