<?php

namespace WPML\TM\ATE;


use WPML\FP\Cast;
use WPML\FP\Fns;
use WPML\FP\Obj;

class Jobs {
	/**
	 * @param array $statuses
	 *
	 * @return array
	 */
	public static function getJobsWithStatus( array $statuses ) {
		if ( ! $statuses ) {
			return [];
		}

		global $wpdb;

		$statuses = \wpml_prepare_in( $statuses, '%d' );

		$sql = "
			SELECT jobs.rid, jobs.job_id as jobId, jobs.editor_job_id as ateJobId, jobs.automatic , translations.status, translations.review_status
			FROM {$wpdb->prefix}icl_translate_job as jobs
			INNER JOIN {$wpdb->prefix}icl_translation_status translations ON translations.rid = jobs.rid
			WHERE jobs.editor = %s AND translations.status IN ({$statuses})
		";

		return Fns::map( Obj::evolve( [
			'rid'       => Cast::toInt(),
			'jobId'     => Cast::toInt(),
			'ateJobId'  => Cast::toInt(),
			'automatic' => Cast::toBool(),
			'status'    => Cast::toInt(),
		] ), $wpdb->get_results( $wpdb->prepare( $sql, \WPML_TM_Editors::ATE ) ) );
	}

	/**
	 * @return array
	 */
	public static function getJobsToSync() {
		return self::getJobsWithStatus( [ ICL_TM_WAITING_FOR_TRANSLATOR, ICL_TM_IN_PROGRESS ] );
	}

	/**
	 * @return array
	 */
	public static function getJobsToRetry() {
		return self::getJobsWithStatus( [ ICL_TM_ATE_NEEDS_RETRY ] );
	}

	/**
	 * @return int
	 */
	public static function getTotal() {
		global $wpdb;

		$sql = "
			SELECT COUNT(jobs.job_id)
			FROM {$wpdb->prefix}icl_translate_job as jobs
			WHERE jobs.editor = %s
		";

		return (int) $wpdb->get_var( $wpdb->prepare( $sql, \WPML_TM_Editors::ATE ) );
	}
}
