<?php

namespace WPML\TM\ATE;

use WPML\LIB\WP\Hooks;
use WPML\LIB\WP\User;
use function WPML\FP\spreadArgs;
use WPML\Setup\Option;

class StatusBar {

	public static function add_hooks() {
		if (
			User::getCurrent()->has_cap( \WPML_Manage_Translations_Role::CAPABILITY )
			&& Option::shouldTranslateEverything()
		) {
			Hooks::onAction( 'admin_bar_menu', 999 )
			     ->then( spreadArgs( [ self::class, 'add' ] ) );
		}
	}

	public static function add( \WP_Admin_Bar $adminBar ) {
		$iconurl = "'" . ICL_PLUGIN_URL . '/res/img/icon16.png' . "'";

		$iconspan = '<span class="" style="
    float:left; width:22px !important; height:22px !important;
    margin-left: 5px !important; margin-top: 5px !important;
    background-image:url(' . $iconurl . ');"></span>';

		$title = '<div id="wpml-status-bar-count" style="display:inline-block"></div>';
		$adminBar->add_node(
			[
				'parent' => false,
				'id'     => 'ate-status-bar',
				'title'  => $iconspan . $title,
				'href'   => false
			]
		);
		$adminBar->add_node(
			[
				'parent' => 'ate-status-bar',
				'id'     => 'ate-status-bar-content',
				'meta'   => [ 'html' => '<div id="wpml-ate-status-bar-content"></div>' ],
				'href'   => false,
			]
		);
	}

	public static function getNotices() {
		return [];
	}
}
