<?php


namespace WPML\TM\ATE\AutoTranslate\Endpoint;


use WPML\Ajax\IHandler;
use WPML\Collect\Support\Collection;
use WPML\FP\Either;
use WPML\Utilities\KeyedLock;
use function WPML\Container\make;

class SyncLock implements IHandler {

	const LOCK_RELEASE_TIMEOUT = 2 * MINUTE_IN_SECONDS;
	const LOCK_NAME = 'ate_sync';

	public function run( Collection $data ) {
		/** @var KeyedLock $lock */
		$lock = make( KeyedLock::class, [ ':name' => self::LOCK_NAME ] );

		$action = $data->get( 'action', 'acquire' );

		if ( $action === 'release' ) {
			$lock->release();

			return Either::of( [ 'action' => 'release', 'result' => true ] );
		} else {
			return Either::of( [ 'action' => 'acquire', 'result' => $lock->create( null, self::LOCK_RELEASE_TIMEOUT ) ] );
		}

	}

}