/*jshint browser:true, devel:true */

class ATEJobs {
	/**
	 * @param {Object} obj - An object.
	 * @param {WPMLAPI} obj.wpmlAPI
	 * @param {ATEAPI} obj.ateAPI
	 */
	constructor({wpmlAPI, ateAPI}) {
		this.wpmlAPI = wpmlAPI;
		this.ateAPI = ateAPI;

		/**
		 * @callback createATEJob
		 * @param jobId
		 * @param ateReturnUrl
		 * @param translator
		 */
		this.createATEJob = (jobId, ateReturnUrl, translator) => {
			return this.wpmlAPI.fetchXLIFF(jobId)
				.then((xliff) => {
					return this.ateAPI.createJob({
						xliff,
						ateReturnUrl,
						translator,
					})
						.then(({job_id: ateJobId, job_url: ateJobUrl}) => {
							return this.wpmlAPI.storeATEJob({
								jobId,
								ateJobData: {
									ateJobId,
									ateJobUrl,
								},
							})
								.then(() => {
									return {
										jobId,
										ateJobId,
										ateJobUrl,
									};
								});
						});
				});
		};

		/**
		 * @callback getATEJobStatus
		 * @param ateJobId
		 */
		this.getATEJobStatus = (ateJobId) => {
			return this.ateAPI.getJobStatus(ateJobId)
				.then((json) => {
					return {ateJobUrl: json.job_url};
				});
		};

		this.assignJob = ({jobId, translatorId}) => {
			return this.wpmlAPI.assignJob({
				jobId,
				translatorId,
			});
		};
	}
}

export default ATEJobs;
