/** globals ate_jobs_sync **/

import * as R from "ramda";
import {__} from "wpml-common-js-source/src/i18n";
import {callEndpoint} from "wpml-common-js-source/src/Ajax";
import {createStatusIconUpdater, JobsSync} from "./JobsSync";
import {JOB_STATUSES} from "../jobs/model/jobs";
import ATEAPI from "./API/ATEAPI";
import Request from "../shared/Request";

const autoTranslateEndpoint = R.path(['endpoints', 'auto-translate'], ate_jobs_sync);

const setToolTip = (icon, content) => {
	if (icon._tippy) {
		icon._tippy.setContent(content);
	}
}

const showSending = icon => {
	icon.classList.replace('otgs-ico-add', 'otgs-ico-refresh-spin');
	setToolTip(icon, __('Sending for translation', 'wpml-translation-management'));
}

const sendToTranslation = async (event) => {
	const link = event.currentTarget,
		trid = link.dataset.trid,
		language = link.dataset.language,
		icon = link.querySelector('i.otgs-ico-add');

	event.preventDefault();
	link.removeEventListener('click', sendToTranslation);

	showSending(icon);
	const {data: {success, data}} = await callEndpoint(autoTranslateEndpoint, {
		trid,
		language
	});

	if (success && data) {
		link.dataset.tmJobId = data.jobId;
		window.setTimeout(R.partial(checkStatus, [[data.jobId]]), 5000);
	}
};

const checkStatus = async (jobs) => {
	const ateAPI = new ATEAPI(new Request());
	const jobSync = JobsSync(createStatusIconUpdater(), ateAPI, {
		setNotEnoughCredit: R.identity,
		setJobsToSync: R.identity,
	});

	jobs = await jobSync(jobs);

	jobs = R.filter(R.propEq('status', JOB_STATUSES.IN_PROGRESS), jobs);
	if (!R.isEmpty(jobs)) {
		setTimeout(() => checkStatus(jobs), 5000);
	}
};

const refreshStatusInLanguagesMetaBox = () => {
	const links = document.querySelectorAll('.js-wpml-translate-link');

	let jobs = []
	links.forEach(link => {
		jobs.push({'jobId' : parseInt(link.dataset.tmJobId), 'automatic': true, status: JOB_STATUSES.IN_PROGRESS})
	});

	checkStatus(jobs);
}

const initializeAutoTranslationTriggeredManually = () => {
	const links = document.querySelectorAll('.js-wpml-translate-link[data-auto-translate="1"]');
	links.forEach(link => {
		if (link.querySelector('i.otgs-ico-add')) {
			link.addEventListener('click', sendToTranslation);
		}
	});
}


export const initializeAutoTranslate = () => {
	if (ate_jobs_sync.isAutomaticTranslations) {
		initializeAutoTranslationTriggeredManually();

		document.addEventListener('WPMLLanguagesMetaBoxesRefreshed', refreshStatusInLanguagesMetaBox);
	}
};
