import {JOB_STATUSES} from "../jobs/model/jobs";
import {map, filter, includes, pipe} from 'ramda';
import {subscribe} from '../../../../../../src/js/shared/event';
import initTooltip from '../jobs/util/tooltip';

const getCheckbox = jobId => document.querySelector(`.js-wpml-translate-link[data-tm-job-id="${jobId}"]`).
                                      closest('tr').
                                      querySelector('input[type="checkbox"]');

const getAllCheckboxes = () => document.querySelectorAll('#icl-tm-translation-dashboard tr input[type="checkbox"]');

const getParent = element => element.closest('td');

const jobElements = () => document.querySelectorAll('span.js-wpml-translate-link');

export const initTranslationDashboardJobsActions = (hooks, tooltipText) => {
	const disable = element => {
		element.checked = false;
		element.disabled = true;

		const parent = getParent(element);
		parent.setAttribute('title', tooltipText);
		if (!parent._tippy) {
			initTooltip(parent, 'otgs');
		}
	};

	const enable = element => {
		element.disabled = false;

		const parent = getParent(element);
		parent.removeAttribute('title');
		if (parent._tippy) {
			parent._tippy.destroy();
		}
	};

	const updateJobsStatuses = () => {
		const enabledStatuses = [
			JOB_STATUSES.COMPLETED,
			JOB_STATUSES.CANCELLED,
		];
		const updateCheckBoxStatus = element => {
			const checkbox = getCheckbox(element.dataset.tmJobId);

			if (
				element.dataset.automatic !== '1'
				|| includes(parseInt(element.dataset.document_status), enabledStatuses)
			) {
				enable(checkbox);
			} else {
				disable(checkbox);
			}
		};

		const updateExistingJobs = pipe(
			filter(element => parseInt(element.dataset.tmJobId)),
			map(updateCheckBoxStatus),
		);

		updateExistingJobs(jobElements());
	};

	hooks.addAction('wpml-tm-ate-after-sync', 'updateJobs', updateJobsStatuses);

	subscribe('translate-everything-running').then(
		running => running ? map(disable, getAllCheckboxes()) : updateJobsStatuses(),
	);
};
