/** globals ate_jobs_sync **/
import {initializeAutoTranslate} from '../AutoTranslate';
import {initializeStatusBar} from '../status-bar/init';
import {initializeTranslationModeStatus} from "../translate-everything/init";
import initializeTranslationQueue from "../../translationQueue/init";
import {initTranslationDashboardJobsActions} from '../TranslationDashboardJobsActions';
import {createHooks} from '@wordpress/hooks';
import React from "react";
import {createSharedStore} from "../status-bar/store";
import './style/index.scss';
import {enableAte} from "../enable/init";
import {subscribe} from "../../../../../../../src/js/shared/event";
import {initialize as initializeReview} from "../review/init";

export const hooks = createHooks();

const initialize = () => {
	initializeAutoTranslate();
	if (ate_jobs_sync.isTranslationManager === '1') {
		if (ate_jobs_sync.isAutomaticTranslations === '1') {
			initializeStatusBar();
			initTranslationDashboardJobsActions(hooks, ate_jobs_sync.strings.automaticTranslation);
		}
	}
	initializeTranslationModeStatus();
}

document.addEventListener('DOMContentLoaded', () => {
    createSharedStore(ate_jobs_sync, hooks);
    initializeTranslationQueue();
    initializeReview();

	if (ate_jobs_sync.isAteActive === '1') {
		initialize();
	} else if( ate_jobs_sync.editorMode === 'ATE' ) {
		enableAte();
		subscribe('ateEnabled')
			.then(initialize);
	}
});

