import initTooltip from "../../jobs/util/tooltip";
import {__} from "wpml-common-js-source/src/i18n";
import {subscribe} from "wpml-common-js-source/src/event";

const changeNodeTag = (node, tag) => {
	const newNode = document.createElement(tag);
	newNode.innerHTML = node.innerHTML;
	node.parentNode.replaceChild(newNode, node);
	return newNode;
};

const disableLink = icon => changeNodeTag(icon.parentNode, 'span').children[0];

const changeTooltip = icon => {
	icon.setAttribute(
		'title',
		__("You don't have the rights to review this language", "wpml-translation-management")
	);
	initTooltip(icon, 'otgs');
};

const getIconsUserCannotTranslate = () => [...document.querySelectorAll('.js-wpml-translate-link[data-user-can-translate="no"] i')];

const updateIcons = () => {
	getIconsUserCannotTranslate()
		.filter(icon => icon.classList.contains('otgs-ico-needs-review'))
		.map(disableLink)
		.map(changeTooltip)
}

export const initialize = () => {
	updateIcons()
	subscribe('job-link-updated').then(updateIcons);
};
