/** globals ate_jobs_sync **/

import React from 'react';
import {__} from "wpml-common-js-source/src/i18n";
import {useStoreState} from 'easy-peasy';
import {always, cond, gt, identity} from "ramda";
import Row from "antd/lib/row";
import "antd/lib/grid/style/index.css";
import Space from "antd/lib/space";
import "antd/lib/space/style/index.css";

export default ({isAdminBar = false}) => {
	const {automaticJobsInProgress, notEnoughCredit} = useStoreState(identity);

	const status = cond([
		[() => notEnoughCredit, always('problem')],
		[() => automaticJobsInProgress > 0, always('inProgress')],
		[() => automaticJobsInProgress === 0, always('complete')],
		[always(true), always(null)]
	])();

	const progressDisplay = isAdminBar
		? <ProgressAdminBar status={automaticJobsInProgress} icon={status}/>
		: <Progress status={automaticJobsInProgress} icon={status}/>;

	return <>
		{status && progressDisplay}
	</>
};

const Progress = ({status, icon}) => (
	<>
		<Row>
			<Space>
				<ProgressIcon status={icon}/>
				<h1 className='progress'>{status > 0 ? status : __('All translated', 'wpml-translation-management')}</h1>
				{status > 0 && <div className='small-gray'>
						<Row>{__('translations', 'wpml-translation-management')}</Row>
						<Row>{__('left', 'wpml-translation-management')}</Row>
					</div>
				}
			</Space>
		</Row>
	</>
)

const getStatusText = status => status > 0
	? sprintf(__('%d translations left', 'wpml-translation-management'), status)
	: __('All translated', 'wpml-translation-management');

const ProgressAdminBar = ({status, icon}) => (
	<>
		<Row className='progress'>
			<Space>
				<ProgressIcon status={icon}/>{getStatusText(status)}
			</Space>
		</Row>
	</>
)

export const ProgressIcon = ({status}) => {
	const colors = {
		'inProgress': '#FF9F47',
		'complete': '#27AD95',
		'problem': '#D96800'
	};
	const style = {
		height: '9px',
		width: '9px',
		backgroundColor: colors[status],
		borderRadius: '50%',
		display: 'inline-block'
	};
	return <span style={style}></span>
}
