import React from 'react';
import {useStoreState} from 'easy-peasy';
import {identity, propEq} from "ramda";

export default () => {
	const {notices} = useStoreState(identity),
		count = notices.length,
		important = notices.filter(propEq('type', 'important')).length,
		status = important ? 'important' : 'information';

	const colors = {
		'information': '#0082AB',
		'important': '#D24829'
	};
	const style = {
		height: '16px',
		width: '16px',
		backgroundColor: colors[status],
		borderRadius: '50%',
		display: 'inline-block',
		color: '#fff',
		textAlign: 'center',
		verticalAlign: 'text-bottom',
		lineHeight: 1
	};
	return <>
		{count ? <span style={style}>{count}</span> : ''}
	</>

};
