import React from 'react';
import {identity} from "ramda";
import {useStoreState} from 'easy-peasy';
import AteJobsStatus from "../AteJobsStatus";
import Sending from "../sending";
import Notices from "../notices";
import "./style/index.scss";

export default () => {
	const {notices, shouldTranslateEverything} = useStoreState(identity);

	return <div className={'wpml-status-bar'} style={{width : "100%"}}>
		<AteJobsStatus isAdminBar={true}/>
		{shouldTranslateEverything && <Sending/>}
		{notices.length > 0 && <><hr/><Notices notices={notices}/></>}
	</div>
};
