import React           from 'react';
import {useStoreState} from 'easy-peasy';
import {__, sprintf}   from "wpml-common-js-source/src/i18n";
import Row             from "antd/lib/row"
import Col             from "antd/lib/col"
import "antd/lib/grid/style/index.css";
import {identity}      from "ramda";
import "./style/index.scss";
import Space           from "antd/lib/space";
import "antd/lib/space/style/index.css";
import Popover         from "antd/lib/popover";
import "antd/lib/popover/style/index.css";
import "../../../../../../../../../src/scss/antd/motion.scss";
import Spin            from "antd/lib/spin";
import "antd/lib/spin/style/index.css";

export default () => {
    const {credits, fetchingCredits} = useStoreState(identity);

    return <>{
        credits
        ? (credits.error ? <ShowError/> : <ShowCredits credits={credits} isFetching={fetchingCredits}/>)
        : ''
    }</>
}

const ShowCredits = ({credits, isFetching}) => {
    return <div style={{minHeight: '50px'}}>
        {
            isFetching ? <Spin spinning={true}/> : <Row>
                <Col span={10}>
                    <PrepaidCredits credits={credits}/>
                </Col>
                {credits.active_subscription && <Col span={12} offset={2}>
                    <Subscription credits={credits}/>
                </Col>
                }
            </Row>
        }
    </div>;
};

const PrepaidCredits = ({credits}) => {

    const creditsLeft = credits.available_balance > credits.subscription_max_limit
                        ? credits.available_balance - credits.subscription_max_limit
                        : 0;

    const tip = <p style={{width: 150}}>
        {__('Remaining prepaid credits that are assigned to this site on WPML.org.', 'wpml-translation-management')}
    </p>;

    return <Popover
					overlayClassName={'ant-popover-dark'}
        title={null}
        content={tip}
    >
        <Row>
            <Col className={'wpml-credit'}>
                <span><strong>{creditsLeft}</strong></span>
            </Col>
        </Row>
        <Row>
            <Space className={'small-gray'}>{__('Prepaid credits left', 'wpml-translation-management')}</Space>
        </Row>
    </Popover>
}

const Subscription = ({credits}) => {

    const subscriptionCredits = <><strong>{credits.subscription_usage}</strong> / {credits.subscription_max_limit}</>;

    return <Popover
					overlayClassName={'ant-popover-dark'}
        title={null}
        content={<SubscriptionTip credits={credits}/>}
    >
        <Row>
            <Col className={'wpml-subscription'}>
                <span>{subscriptionCredits}</span>
            </Col>
        </Row>
        <Row>
            <Space className={'small-gray'}>{__('Account credits used', 'wpml-translation-management')}</Space>
        </Row>
    </Popover>
}

const SubscriptionTip = ({credits}) => (
    <>
        <p style={{width: 250}}>
            {__('Once you’ve used all your prepaid credits, we’ll invoice you for any additional credits you use after the end of the month', 'wpml-translation-management')}
        </p>
        <table>
            <tbody>
            <tr>
                <td>{__('Payment limit:', 'wpml-translation-management')}</td>
                <td>{sprintf(__('%s credits', 'wpml-translation-management'), credits.subscription_max_limit)}</td>
            </tr>
            <tr>
                <td>{__('Credits used:', 'wpml-translation-management')}</td>
                <td>{credits.subscription_usage}</td>
            </tr>
            <tr>
                <td>{__('Credits left:', 'wpml-translation-management')}</td>
                <td>{credits.subscription_max_limit - credits.subscription_usage}</td>
            </tr>
            </tbody>
        </table>
    </>
);

const ShowError = () => (
    <>
        {__('Calculating', 'wpml-translation-management')} <Spin size={"small"} spinning={true}/>
    </>
)
