import React from 'react';
import {split, intersperse} from "ramda";
import BellIcon from "../BellIcon";
import Button from "antd/lib/button";
import "antd/lib/space/style/index.css"
import Row from "antd/lib/row";
import Col from "antd/lib/col";
import "antd/lib/grid/style/index.css";
import ArrowLinkIcon from "../../../../../../../../../src/icons/ArrowLinkIcon.svg";

export default ({notices}) => {
	const addKey = notice => {
		notice.key = notice.text;
		return notice;
	};
	return (
		<ul>
			{notices.map(addKey).map(Notice)}
		</ul>
	);
}

const Notice = ({key, text, href, type, action, target = '_blank'}) => {
	return <li key={key}>
		<div className={'notice-' + type}>
			{href && <a href={href} target={target}><Content text={text}/></a>}
			{!href && action && <a style={{cursor:'pointer'}} onClick={action}><Content text={text}/></a>}
			{!href && !action && <Content text={text}/>}
		</div>
	</li>
};

const Content = ({text}) => {
	const lines = split('\n', text);
	return (
		<Row className={'notice-wrapper'}>
			<Col align={'middle'}>
				<Row className={'notice-wrapper-inner'}>
					<Col align={'middle'}>
						<BellIcon/>
						<p>{lines.join(<br/>)}</p>
					</Col>
				</Row>
				<ArrowLink/>
			</Col>
		</Row>
	)
};

const ArrowLink = ({className = 'arrow-link'}) => (
	<span className={className}>
		<ArrowLinkIcon/>
	</span>
);
