import React from "react";
import {useStoreState} from "easy-peasy";
import {identity} from "ramda";
import {__} from "wpml-common-js-source/src/i18n";
import SendingIcon from "../SendingIcon";

export default () => {
	const {totalJobs} = useStoreState(identity);

	const preparingMore = <span>{__('Preparing more content for translation', 'wpm-translation-management')}</span>;
	const preparing = <span>{__('Preparing content for translation', 'wpml-translation-management')}</span>;

	return <div className='sending'>
		<SendingIcon/>&nbsp;{totalJobs > 0 ? preparingMore : preparing}
	</div>
}
