import {sprintf} from "sprintf-js";
import {__} from "wpml-common-js-source/src/i18n";
import {append, pipe, propEq, reject} from "ramda";

export default {
    createJobsToReviewNotice: (urls, needsReviewCount) => ({
        id: 'needsReview',
        text: sprintf(__("%d translations waiting for review", 'wpml-translation-management'), needsReviewCount),
        type: 'info',
        href: urls.translationQueue,
        target: '_self',
    }),

    createNoCreditNotice: (ateConsole, urls) => ({
        id: 'noCredit',
        text: __("There is an issue with automatic translation that needs your attention. Fix it to continue.", 'wpml-translation-management'),
        action: () => {
            if (ateConsole !== '') {
                head.js(urls.ateConsole, () => LoadEateWidget(ateConsole));
            }
        },
        type: 'important'
    }),

    replaceNotice: (notices, currentNotice) => {
        return pipe(reject(propEq('id', currentNotice.id)), append(currentNotice))(notices);
    },

    removeNotice: (notices, id) => reject(propEq('id', id), notices),
};
