import React from 'react';
import {useStoreState} from 'easy-peasy';
import {__} from "wpml-common-js-source/src/i18n";
import {createInterpolateElement} from '@wordpress/element';
import Notices from "../../../status-bar/components/notices";
import AteJobsStatus from "../../../status-bar/components/AteJobsStatus";
import Card from "antd/lib/card";
import "antd/lib/card/style/index.css";
import Row from "antd/lib/row";
import "antd/lib/grid/style/index.css";
import Col from "antd/lib/col";
import {identity} from "ramda";
import Sending from "../../../status-bar/components/sending";
import LightningIcon from "../../../status-bar/components/lightning-icon";
import Divider from "antd/lib/divider";
import "antd/lib/divider/style/index.css";
import "antd/lib/modal/style/index.css";
import Credit from "../../../status-bar/components/credit";
import "./style/index.scss";

export default ({status=<StatusArea/>}) => {
	return <>
		<Card className={'wpml-auto-translate-status'}>
			<Row className={'wpml-auto-translate-status__row'}>
				<Col span={24} md={15} className={'wpml-auto-translate-status__content'}>
					{status}
				</Col>
				<Col span={24} md={9} className={'wpml-auto-translate-status__notices'}>
					<NoticeArea/>
				</Col>
			</Row>
			<Footer/>
		</Card>
	</>;
};

const StatusArea = () => {
	const {shouldTranslateEverything, totalJobs} = useStoreState(identity);

	const heading = shouldTranslateEverything
		? __('Your site is being automatically translated!', 'wpml-translation-management')
		: __('Automatic Translation Status', 'wpml-translation-management');

	const hasJobs = <Row>
		<Col span={shouldTranslateEverything ? 14 : 24}><AteJobsStatus/></Col>
		{shouldTranslateEverything && <Col span={10}><Sending/></Col>}
	</Row>;

	const hasNoJobs = <Row align={'middle'}>
		<Col span={24} sm={14}>{shouldTranslateEverything && <Preparing text={__('Calculating...', 'wpml-translation-management')}/>}</Col>
		<Col span={24} sm={10}>{shouldTranslateEverything && <Sending/>}</Col>
	</Row>;

	return <>
		<Heading heading={heading}/>
		<Row className={'wpml-auto-translate-status__content-info'}>
			<Col span={24} sm={20} lg={16} xl={14} offset={1} className={'status-first-column'}>
				{shouldTranslateEverything && totalJobs === 0 ? hasNoJobs : hasJobs}
				<Row className={'credits'}>
					<Col span={24}>
						<Credit/>
					</Col>
				</Row>
			</Col>
		</Row>
	</>

};

export const Heading = ({heading}) => (
	<Row align={'middle'}>
		<Col span={24}>
			<LightningIcon/>
			<h3>{heading}</h3>
		</Col>
	</Row>
);

const NoticeArea = () => {
	const {notices, shouldTranslateEverything} = useStoreState(identity);

	return <>
		{shouldTranslateEverything && <Row justify={'end'}><DoNotCloseAdmin/></Row>}
		{notices.length > 0 && <Row className={'wpml-status-notices'} justify={'end'}><Notices notices={notices}/></Row>}
	</>;
};

const DoNotCloseAdmin = () => (
	<div className='do-not-close'>
		{__('Do not close WP admin!', 'wpml-translation-management')}
	</div>
)

export const Preparing = ({text}) => (
	<>
		<h1 className='progress'>{text}</h1>
		<div className='small-gray' style={{display: 'inline-block'}}>
			{__('The number of translations', 'wpml-translation-management')}
		</div>
	</>
)

export const Footer = () => {
	const {shouldTranslateEverything} = useStoreState(identity);

	const hint = createInterpolateElement(
		__('Change your <a>automatic translation settings</a> (in-progress translation jobs will be completed with the current settings).', 'wpml-translation-management'),
		{
			a: <a href={ate_jobs_sync.urls.automaticSettings}/>
		}
	);

	return <>
		<Row><Divider/></Row>
		{shouldTranslateEverything && <Row>
			<p className={'small-gray'}><a
				href={ate_jobs_sync.urls.translateAutomaticallyDoc}>{__('Read more about translating your site automatically.', 'wpml-translation-management')}</a>
			</p>
		</Row>}
		<Row>
			<p className={'small-gray'}>{hint}</p>
		</Row>
	</>;
}
