import React from 'react';
import ReactDOM from 'react-dom';

import {ConnectedJobsTab} from './components/JobsTab';
import {ConnectedJobProvider} from "./context/JobsProvider";
import {SettingsProvider} from "./context/SettingsProvider";
import {StringsProvider} from "./context/StringsContext";

const app = (
	<StringsProvider>
		<SettingsProvider>
			<ConnectedJobProvider>
				<ConnectedJobsTab/>
			</ConnectedJobProvider>
		</SettingsProvider>
	</StringsProvider>
);

const root = document.querySelector("#wpml-remote-jobs-container");
ReactDOM.render(app, root);