import React from 'react';

import {connectedListItem as ListItem} from './ListItem';
import {ConnectedListHeader as ListHeader} from './ListHeader';
import {ATE_JOBS_STATUSES} from '../model/jobs';

class JobKeyGenerator {

	constructor() {
		this.jobs = {};
	}

	getKey(job) {
		let key = job.id + '_' + job.type;
		let suffix = 0;

		if (key in this.jobs) {
			suffix = ++this.jobs[key];
		} else {
			this.jobs[key] = 0;
		}

		if (suffix) {
			key += '_' + suffix;
		}

		return key;
	}
}

const keyGenerator = new JobKeyGenerator();

const List = ({jobs = []}) => (

	<table className="widefat striped wpml-translation-jobs">
		<thead>
		<ListHeader key="top-header"/>
		</thead>
		<tbody>
		{
			jobs.filter(job => ATE_JOBS_STATUSES.HIDDEN !== job.status).map((job) => (
				<ListItem
					key={keyGenerator.getKey(job)}
					job={job}
				/>
			))
		}
		</tbody>
		<tfoot>
		<ListHeader key="bottom-header"/>
		</tfoot>
	</table>

);

export default List;