import {JOB_STATUSES} from "../../../context/JobsProvider";
import Action from "./Action";
import {canBeTranslationDownloaded, isLocal} from "../../../model/jobs";
import React from "react";

import connect from "../../../context/connect";
import {JobsConsumer} from "../../../context/JobsProvider";
import {StringsConsumer} from "../../../context/StringsContext";

const disabledTooltip = (strings, job) => {
	let disabledTitle = "";

	if (isLocal(job)) {
		disabledTitle = strings.localJob;
	} else {
		switch (job.status) {
			case JOB_STATUSES.CANCELLED:
				disabledTitle = strings.canceled.replace("TS_NAME", job.translation_service);
				break;
			case JOB_STATUSES.IN_PROGRESS:
				disabledTitle = strings.notReady;
				break;
			case JOB_STATUSES.COMPLETED:
				disabledTitle = strings.completed;
				break;
		}
	}

	return disabledTitle;
};

export const DownloadTranslations = ({
	                                     applyTranslations,
	                                     strings: {jobActions: {getTranslations: strings}},
	                                     job
                                     }) => (
	<Action
		isActive={canBeTranslationDownloaded(job)}
		icon="otgs-ico-file"
		onClick={() => applyTranslations([job])}
		strings={{
			activeTitle: strings.activeIconText,
			disabledTitle: disabledTooltip(strings, job)
		}}
	/>
);

export default connect(DownloadTranslations, StringsConsumer, JobsConsumer);
