import React from "react";
import {JOB_STATUSES} from "../../../model/jobs";

const getLocalStatusDescription = (jobsStatuses, job) => {
	let text = jobsStatuses[job.status];

	if (job.needs_update) {
		text += ` - ${jobsStatuses[JOB_STATUSES.NEEDS_UPDATE]}`;
	}

	if (!job.tp_id && job.progress && job.status !== JOB_STATUSES.COMPLETED) {
		text += ` (${job.progress})`;
	}

	return text;
};

const getExternalStatusDescription = job => {
	if (job.tp_id && job.ts_status) {
		return <span style={{display: 'none'}}>({job.ts_status.status})</span>;
	}

	return '';
};

const Status = ({jobsStatuses, job}) => {
	return <td>{getLocalStatusDescription(jobsStatuses, job)}{getExternalStatusDescription(job)}</td>;
};

export default Status;