import React from 'react';
import connect from "../../../jobs/context/connect";
import {StringsConsumer} from "../../../jobs/context/StringsContext";
import {SettingsConsumer} from "../../../jobs/context/SettingsProvider";

export const Language = ({
	                         value,
	                         label,
							 id,
	                         onChange,
	                         languages,
	                         strings
                         }) => (
	<span>
		<label htmlFor={id}>
			{label}
		</label>
		<select
			id={id}
			value={value}
			onChange={e => onChange(e.target.value)}
		>
			<option value="any">{strings.filters.anyLanguage}</option>
			{
				Object.entries(languages).map(({0: code, 1: name}) => (
					<option value={code} key={code}>{name}</option>
				))
			}
		</select>
	</span>
);

export default connect(Language, StringsConsumer, SettingsConsumer);