import React from 'react';
import Language from "./Language";
import MultiSelect from "./MultiSelect";
import connect from "../../context/connect";
import {StringsConsumer} from "../../context/StringsContext";
import {SettingsConsumer} from "../../../jobs/context/SettingsProvider";
import {dissoc, without, join, split, pipe} from "ramda";

export const Languages = ({
							  value,
							  strings,
							  onChange,
							  languages
						  }) => {


	return <span>
		<Language
			id="source-language"
			value={value.source}
			label={strings.filters.languageFrom}
			onChange={source => {
				const removeSource = pipe(split(','), without(source), join(','))

				onChange({
					target: removeSource(value.target),
					source
				})
			}}

		/>

		<MultiSelect
			id="target-language"
			label={strings.filters.languageTo}
			onChange={target => onChange({
				...value,
				target
			})}
			value={value.target}
			options={dissoc([value.source], languages)}
		/>
	</span>
};

export default connect(Languages, StringsConsumer, SettingsConsumer);
