import React from 'react';
import Select from 'react-select'

export default ({
	                value,
	                label,
	                id,
	                onChange: onChangeHandler,
	                options,
	                placeholder
                }) => (
	<span>
		<label htmlFor={id}>
			{label}
		</label>
		<Select
			id={id}
			value={
				value.length ?
					value.split(',').map(value => ({value, label: options[value]}))
					: []
			}
			isMulti
			options={Object.entries(options).map(({0: value, 1: label}) => ({
				value, label
			}))}
			styles={{
				control: (base, state) => ({
					...base,
					borderColor: state.isFocused ? '#5b9dd9' : '#ddd',
					boxShadow: state.isFocused ? '0 0 2px rgba(30,140,190,.8)' : 'inset 0 1px 2px rgba(0,0,0,.07)',
					minHeight: "25px",
				}),
				dropdownIndicator: (base) => ({
					...base,
					padding: '3px'

				}),
				clearIndicator: (base) => ({
					...base,
					padding: '3px'

				}),
				valueContainer: (base) => ({
					...base,
					padding: '0 2px'

				}),
			}}
			className="basic-multi-select"
			classNamePrefix="select"
			onChange={selectedOptions => onChangeHandler(selectedOptions.map(({value}) => value).join(","))}
			placeholder={placeholder}
		/>
	</span>
);