import React from 'react';
import connect from "../../context/connect";
import {StringsConsumer} from "../../context/StringsContext";

export const Sort = ({
	                     label,
	                     onChange: onChangeHandler,
	                     value,
	                     sortOptions,
	                     strings,
	                     disabled = false
                     }) => (
	<span>
		<label>
			{label}
		</label>
		<select
			onChange={e => onChangeHandler({
				...value,
				sort: e.currentTarget.value
			})}
			value={value.sort}
			title={strings.filters.sort}
			disabled={disabled}
		>
			<option value="-">-</option>
			{
				Object.entries(sortOptions).map(({0: value, 1: description}) => (
					<option key={value} value={value}>{description}</option>
				))
			}
		</select>
		<select
			onChange={e => onChangeHandler({
				...value,
				direction: e.currentTarget.value
			})}
			value={value.direction}
			title={strings.filters.direction}
			disabled={disabled}
		>
			<option value="asc">{strings.filters.asc}</option>
			<option value="desc">{strings.filters.desc}</option>
		</select>
	</span>
);


export default connect(Sort, StringsConsumer);
