import React from 'react';
import Sort from "./Sort";

import connect from "../../context/connect";
import {StringsConsumer} from "../../context/StringsContext";
import {SettingsConsumer} from "../../../jobs/context/SettingsProvider";

const filterColumnsInSecondSort = (value, sortable) => {
	if (value.first.sort !== '-') {
		const {[value.first.sort]: discard, ...filteredSortable} = sortable;
		return filteredSortable;
	} else {
		return {};
	}
};

export const Sorts = ({
	                      strings,
	                      value,
	                      onChange,
	                      sortable
                      }) => {

	strings = strings.filters;

	return (
		<span>
			<Sort
				key="first-sort"
				onChange={first => onChange({
					...value,
					first
				})}
				value={value.first}
				sortOptions={sortable}
				label={strings.firstSort}
			/>

			<Sort
				key="second-sort"
				onChange={second => onChange({
					...value,
					second
				})}
				value={value.second}
				sortOptions={filterColumnsInSecondSort(value, sortable)}
				label={strings.secondSort}
				disabled={value.first.sort === '-'}
			/>
		</span>
	);
};

export default connect(Sorts, StringsConsumer, SettingsConsumer);