import React from 'react';

import connect from "../../context/connect";
import {StringsConsumer} from "../../context/StringsContext";
import {SettingsConsumer} from "../../../jobs/context/SettingsProvider";

const buildResponse = value => {
	const defaultResponse = {
		scope: "all",
		value: 0
	};

	switch (value) {
		case "any-service":
			return {
				scope: "remote",
				value: 0
			};
		case "any-local-translator":
			return {
				scope: "local",
				value: 0
			};
		default:
			if (value.includes("translator-")) {
				const translatorId = parseInt(value.substr("translator-".length));
				return {
					scope: "local",
					value: translatorId
				};
			} else if (value.includes("service-")) {
				const serviceId = parseInt(value.substr("service-".length));
				return {
					scope: "remote",
					value: serviceId
				};
			}

			return defaultResponse;
	}
};

export const TranslatedBy = ({
	                             value,
	                             strings,
	                             translatedByFilters,
	                             onChange
                             }) => (
	<span>
		<label htmlFor="translated_by">
			{strings.filters.translatedBy}
		</label>
		<select
			id="translated_by"
			onChange={e => onChange(buildResponse(e.currentTarget.value))}
		>
			{
				translatedByFilters.options.map(({value, label}) => (
					<option value={value} key={value}>{label}</option>
				))
			}
			{
				translatedByFilters.services.map(({value, label}) => (
					<option value={`service-${value}`} key={value}>{label}</option>
				))
			}
			{
				translatedByFilters.translators.map(({value, label}) => (
					<option value={`translator-${value}`} key={value}>{label}</option>
				))
			}
		</select>
	</span>
);

export default connect(TranslatedBy, StringsConsumer, SettingsConsumer);