import React, {Component} from 'react';

import {JobsConsumer} from "./JobsProvider";
import connect from "./connect";

const SelectionContext = React.createContext({});

export class SelectionProvider extends Component {
	constructor(props) {
		super(props);

		this.state = {
			selectedJobs: new Map(),
			allSelected: false
		}
	}

	selectJob(job, isSelected = true) {
		this.setState((state) => {
			state.selectedJobs.set(job, isSelected);
			state.allSelected = this.areAllSelected(this.props.jobs);

			return state;
		});
	}

	isJobSelected(job) {
		return this.state.selectedJobs.has(job) && this.state.selectedJobs.get(job)
	}

	selectAll(isSelected = true) {
		this.setState((state) => {
			state.selectedJobs = new Map(this.props.jobs.map((job) => [job, isSelected]));
			state.allSelected = isSelected;

			return state;
		});
	}

	areAllSelected() {
		return this.props.jobs.find((job) => !this.isJobSelected(job)) === undefined;
	}

	getSelectedJobs() {
		const result = [];

		for (let [job, isSelected] of this.state.selectedJobs) {
			if (isSelected) {
				result.push(job);
			}
		}

		return result;
	}

	render() {
		const {children} = this.props;

		return (
			<SelectionContext.Provider
				value={{
					selectJob:       (job, isSelected) => this.selectJob(job, isSelected),
					selectAll:       (isSelected) => this.selectAll(isSelected),
					isJobSelected:   (job) => this.isJobSelected(job),
					getSelectedJobs: () => this.getSelectedJobs(),
					allSelected: this.state.allSelected
				}}
			>
				{children}
			</SelectionContext.Provider>
		);
	}
}

export const SelectionConsumer = SelectionContext.Consumer;

export const ConnectedSelectionProvider = connect(SelectionProvider, JobsConsumer);