/*globals WPML_TM_SETTINGS */

import React, {Component} from 'react';

const StringsContext = React.createContext({});

export class StringsProvider extends Component {

	constructor(props) {
		super(props);

		this.strings = WPML_TM_SETTINGS.strings;
	}


	render() {
		const {children} = this.props;

		return (
			<StringsContext.Provider
				value={{
					strings: this.strings,
				}}
			>
				{children}
			</StringsContext.Provider>
		);
	}
}

export const StringsConsumer = StringsContext.Consumer;
