import JobsAPI from '../api/JobsAPI';
import saveAs from 'file-saver';
import Request from "../../shared/Request";

export class DownloadXLIFF {
	/**
	 *
	 * @param {JobsAPI} jobsAPI
	 */
	constructor(jobsAPI) {
		this.jobsAPI = jobsAPI;
	}

	async run(job) {
		const xliffContent = await this.jobsAPI.downloadXLIFF(job);
		saveAs(xliffContent, `job-${job.id}.xliff`);
	}
}


