import Tools from "./Shared/Tools";
import * as R from 'ramda';

class ATEControlsUI {
	constructor({preventReload = false} = {}) {
		this.preventReload = preventReload;
		this.tools         = new Tools();
	}

	clearCache() {
		this.ateControls        = null;
		this.synchronizeWithAMS = null;
		this.status             = null;
		this.errors             = null;
		this.spinner            = null;
	}

	initEventHandlers() {
		if (this.getAteConsoleLink()) {
			this.getAteConsoleLink().onclick = (e) => {
				if (this.preventReload) {
					this.tools.hide(e.currentTarget);
				} else {
					return window.location.reload(true);
				}
			};
		}
	}


	isStatusOnly() {
		return this.getAteControls() && this.getAteControls().hasAttribute('data-status-only');
	}

	getAteControls() {
		if (!this.ateControls) {
			this.ateControls = document.getElementById('ate-controls');
		}
		return this.ateControls;
	}

	getStatus() {
		if (this.getAteControls() && !this.status) {
			this.status = this.getAteControls().querySelector('.otgs-notice__status');
		}
		return this.status;
	}

	getErrors() {
		if (this.getAteControls() && !this.errors) {
			this.errors = this.getAteControls().querySelector('.otgs-notice__errors');
		}
		return this.errors;
	}

	getSpinner() {
		if (this.getAteControls() && !this.spinner) {
			this.spinner = this.getAteControls().querySelector('.spinner');
		}
		return this.spinner;
	}

	getAteConsoleLink() {
		if (this.getAteControls()) {
			return this.getAteControls().querySelector('.js-ate-console');
		}
		return null;
	}

	updateAteConsoleLink(url) {
		if (this.getAteConsoleLink()) {
			this.getAteConsoleLink().href = url;
		}
	}

	showStatus({status, statusTypes}) {
		this.getStatus() && this.tools.show(this.getStatus());
		this.getStatus().querySelector('p').innerHTML = this.getStatusHTML(status.message);
		this.getStatus().classList.remove(...statusTypes);
		this.getStatus().classList.add(status.type);

	}

	updateErrors(error) {
		if (this.getErrors()) {
			if (error) {
				let errHtml = "<strong>" + R.propOr("WPML's Advanced Translation Editor is not working", "header", error) + "</strong>";
				errHtml += "<br/>";
				errHtml += "<p>" + R.propOr("", "description", error);

				this.getErrors().querySelector('.message').innerHTML = errHtml;
				this.showErrors();
			} else {
				this.hideErrors();
			}
		}
	}

	setControlsVisibility(visible) {
		if (visible) {
			this.showAteControls();
		} else {
			this.hideAteControls();
		}
	}

	showAteControls() {
		this.getAteControls() && this.tools.show(this.getAteControls());
		this.updateActions();
	}

	hideAteControls() {
		this.getAteControls() && this.tools.hide(this.getAteControls());
	}

	hideAteConsoleLink() {
		this.getAteConsoleLink() && this.tools.hide(this.getAteConsoleLink());
	}

	getStatusHTML({status, text}) {
		return `<strong>${status}</strong> ${text}`;
	}

	hideStatus() {
		this.getStatus() && this.tools.hide(this.getStatus());
	}

	hideErrors() {
		this.getErrors() && this.tools.hide(this.getErrors());
	}

	showSpinner() {
		this.getSpinner() && this.getSpinner().classList.add('is-active');
	}

	hideSpinner() {
		this.getSpinner() && this.getSpinner().classList.remove('is-active');
	}

	showErrors() {
		this.getErrors() && this.tools.show(this.getErrors());
	}

	updateActions(statusOnly = false) {
		if (this.isStatusOnly() || statusOnly) {
			this.clearCache();
			this.hideAteConsoleLink();
		}
	}
}

export default ATEControlsUI;
