import WPMLTMSettings from '../../shared/WPMLTMSettings';

class OldJobsEditor extends WPMLTMSettings {

	constructor () {
		super();

		this.options = [];

		this.form = document.getElementById('icl_doc_translation_method');
		if (this.form) {
			this.options = this.form.querySelectorAll('.wpml-old-jobs-editor [name="wpml-old-jobs-editor"]');
			this.submitButton = this.form.querySelector('.button-primary');

			if (this.submitButton) {
				this.initEventHandlers();
			}
		}
	}

	initEventHandlers () {
		for (let i = 0; i < this.options.length; ++i) {
			const option = this.options[i];
			option.onclick = () => this.submitButton.click();
		}
	}
}

export default OldJobsEditor;