class Tools {

	constructor() {
		this.SCROLL_TO_TOP = 1;
		this.SCROLL_TO_BOTTOM = 2;
	}

    show(element, useStyle = false) {
        if (useStyle) {
            element.style.display = null;
        }
        element.classList.remove('hidden');
    }

    hide(element, useStyle = false) {
        if (useStyle) {
            element.style.display = 'none';
        }
        element.classList.add('hidden');
    }

    showSpinner(element) {
        element.classList.add('is-active');
    }

    hideSpinner(element) {
        element.classList.remove('is-active');
    }

    enableElement(element) {
        element.classList.remove('disabled');
    }

    disableElement(element) {
        element.classList.add('disabled');
    }

	scrollTo(el, scroll_to = this.SCROLL_TO_TOP, duration) {
		let to;
		const rect = el.getBoundingClientRect();
		if ( this.SCROLL_TO_BOTTOM === scroll_to ) {
			to = window.scrollY - window.innerHeight + rect.top + rect.height;
		} else {
			to = window.scrollY + rect.top;
		}

		const
			element = document.scrollingElement || document.documentElement,
			start = element.scrollTop,
			change = to - start,
			startDate = +new Date(),

			easeInOutQuad = function (currentTime, startValue, changeInValue, duration) {
				currentTime /= duration / 2;
				if (currentTime < 1) {
					return changeInValue / 2 * currentTime * currentTime + startValue;
				}
				currentTime--;
				return -changeInValue / 2 * (currentTime * (currentTime - 2) - 1) + startValue;
			},

			animateScroll = function () {
				const currentDate = +new Date();
				const currentTime = currentDate - startDate;
				element.scrollTop = parseInt(easeInOutQuad(currentTime, start, change, duration));
				if (currentTime < duration) {
					requestAnimationFrame(animateScroll);
				} else {
					element.scrollTop = to;
				}
			};
		animateScroll();
	}

}

export default Tools;