import WPMLTMSettings from '../../shared/WPMLTMSettings';

class TranslationMethodATE extends WPMLTMSettings {
	/**
	 *
	 * @param {ATEControls} ateControls
	 */
	constructor (ateControls) {
		super();
		this.ateControls = ateControls;

		this.translationMethodForm = document.getElementById('icl_doc_translation_method');

	}

	init () {
		this.updateSelectedOption();
		this.initEventHandlers();
		this.ateControls.init();
		if (this.currentOptionIsATE()) {
			this.ateControls.visibility(true);
			this.ateControls.updateControlsStatus();
        } else {
            this.ateControls.visibility(false);
        }
	}

	updateSelectedOption () {
		if (this.translationMethodForm) {
			this.translationMethodOptions = this.translationMethodForm.querySelectorAll('[type="radio"][name="t_method"]');
			Array.from(this.translationMethodOptions).map(option => {
				if (option.checked) {
					this.selectedOptionValue = option.value;
				}
			});

		}
	}

	currentOptionIsATE () {
		return 'ATE' === this.selectedOptionValue;
	}

	initEventHandlers () {
		if (this.translationMethodOptions) {
			for (let index = 0; index < this.translationMethodOptions.length; index++) {
				this.translationMethodOptions[index].onchange = () => {
					this.updateSelectedOption();
					this.ateControls.visibility(this.currentOptionIsATE());
					this.ateControls.updateControlsStatus();
				};
			}
		}
	}
}

export default TranslationMethodATE;
