import React from 'react';

export default class PaginationControls extends React.Component {

    render() {
        const strings = this.props.strings;
        const paginationModel = this.props.pagination;

        return (
            <span className="paging-input">
                <input className="current-page"
                       id="current-page-selector-top"
                       type="text"
                       name="paged"
                       value={paginationModel.currentPage}
                       size={paginationModel.totalPages.toString().length}
                       aria-describedby="table-paging"
                       onChange={(e) => {
                           return this.props.onChange(e.target.value)
                       }}
                />

                <span className="tablenav-paging-text">
                    {strings.of} <span className="total-pages">{paginationModel.totalPages}</span>
                </span>
            </span>
        );
    }
}