import React from 'react';
import classNames from 'classnames';

export default ({className, label, onClick, isActive = true}) => {
    const charMap = {
        'first-page':     '«',
        'previous-page':  '‹',
        'next-page':      '›',
        'last-page':      '»'
    };

    if (isActive) {
        return (
			<a className={classNames(className, 'button')} onClick={(e) => {
                e.preventDefault();
                return onClick();
            } } >
                <span className="screen-reader-text">{ label }</span><span aria-hidden="true">{ charMap[className] }</span>
            </a>
        );
    } else {
        return (
            <span className="tablenav-pages-navspan button disabled" aria-hidden="true">
                <span className="screen-reader-text">{label}</span><span aria-hidden="true">{ charMap[className] }</span>
            </span>
        );
    }
};
