/*globals WPML_TM_SETTINGS */

import WPUser from './WPUser';

/**
 * @typedef {Object} WPML_TM_SETTINGS
 * @property {Object} ate
 * @property {Object} currentUser
 * @property {(boolean|string)} hasATEEnabled
 */

/**
 * @typedef {Object} this.ateSettings
 * @property {string} restUrl
 * @property {string} restNonce
 * @property {string} currentStatus
 * @property {Array} statuses
 * @property {WPUser} currentUser
 */

class WPMLTMSettings {
	constructor () {
		this.restUrl = WPML_TM_SETTINGS.restUrl;
		this.restNonce = WPML_TM_SETTINGS.restNonce;
		this.ateSettings = WPML_TM_SETTINGS.ate;
		this.currentUser = new WPUser(WPML_TM_SETTINGS.currentUser);
	}
}

export default WPMLTMSettings;