
class jQueryDialog {
	/**
	 *
	 * @param {jQuery} $
	 * @param {string} dialogId
	 * @param {HTMLElement} content
	 */
	constructor( $, dialogId, content ) {
		this.$ = $;
		this.dialogId = dialogId;
		this.content = content;

		this.maxWidth = '95%';

		this.setupDialog();
	}

	setupDialog() {
		this.dialogElement = this.content.find( `#${this.dialogId}` );
		this.dialogElement.dialog( {
			autoOpen: false,
			resizable: false,
			draggable: false,
			modal: true,
			width: 'auto',
			dialogClass: 'wpml-dialog otgs-ui-dialog',
			closeText: this.dialogElement.data( 'cancel-text' ),
			closeOnEscape: true,
			buttons: this.getButtons()
		} );
	}

	getButtons() {
		return [ this.getDefaultCancelButton() ];
	}

	getDefaultCancelButton() {
		return {
				class: `button-secondary alignleft ${this.dialogId}-cancel`,
				text: this.dialogElement.data( 'cancel-text' ),
				click: () => this.onCancel()
			};
	}

	onCancel() {
		this.close();
	}

	open() {
		this.$(window).on('resize.repositionDialog', () => this.repositionDialog());
		this.dialogElement.dialog('open');
		this.repositionDialog();
	}

	close() {
		this.$(window).off('resize.repositionDialog');
		this.dialogElement.dialog('close');
	}

	destroy() {
		this.dialogElement.dialog( 'destroy' ).remove();
	}

	repositionDialog() {
		this.$('.otgs-ui-dialog .ui-dialog-content').css({
			'max-height': this.$( window ).height() - 180
		});

		this.$('.otgs-ui-dialog').css({
			'max-width': this.maxWidth
		});

		const fullWidthElements = this.getFullWidthElements();
		if ( fullWidthElements.length ) {
			this.dialogElement.find( fullWidthElements.join() ).css( {
				'max-width': '100%'
			} );
		}

		this.setPosition({
			my: 'center',
			at: 'center',
			of: window
		});
	}

	/**
	 *
	 * @returns {Array}
	 */
	getFullWidthElements() {
		return [];
	}

	/**
	 *
	 * @param {string} title
	 */
	setTitle( title ) {
		this.dialogElement.dialog( 'option', 'title', title );
	}

	/**
	 *
	 * @param {string} maxWidth
	 */
	setMaxWidth( maxWidth ) {
		this.maxWidth = maxWidth;
		this.repositionDialog();
	}

	setPosition( position ) {
		this.dialogElement.dialog('option', 'position', position );

	}

	find( selector ) {
		return this.dialogElement.find( selector );
	}
}

export default jQueryDialog;