import React from 'react';
import {StoreProvider} from 'easy-peasy';

import {store} from '../store'
import TranslationMethodSettings from './TranslationMethodSettings';
import '../../../scss/translation-method/style.scss';
import {subscribe} from "../../../../../../../src/js/shared/event";
import {equals} from "ramda";

export default ({method, endpoints, urls, hasSubscription, postTypes, hasTranslationService, reviewMode, isClassicEditor, hasJobsInProgress, disableTranslateEverything}) => {
	const theStore = store(method, endpoints, urls, hasSubscription, postTypes, hasTranslationService, reviewMode, isClassicEditor, hasJobsInProgress, disableTranslateEverything);

	const classicEditor = '1';

	subscribe('editor-mode')
		.then(equals(classicEditor))
		.then(theStore.getActions().setIsClassicEditor);

	return <StoreProvider store={theStore}>
		<TranslationMethodSettings/>
	</StoreProvider>
};
