import {createStore, action, thunk} from 'easy-peasy';
import {callEndpoint} from 'wpml-common-js-source/src/Ajax';
import {setAction} from "../../../../../../src/js/shared/store";
import {path, repeat, zipObj} from "ramda";

export const store = (method, endpoints, urls, hasSubscription, postTypes, hasTranslationService, reviewMode, isClassicEditor, hasJobsInProgress, disableTranslateEverything) => createStore({
	method,
	reviewMode,
	hasSubscription,
	endpoints,
	urls,
	hasJobsInProgress,
	disableTranslateEverything,
	postTypes: zipObj(postTypes, repeat(-1, postTypes.length)),
	saving: false,
	confirmingTranslateEverything: false,
	hasTranslationService,
	isClassicEditor: isClassicEditor,

	setIsClassicEditor: setAction('isClassicEditor'),

	updateMethod: setAction('method'),

	updateReviewMode: setAction('reviewMode'),

	setSaving: setAction('saving'),

	setConfirming: setAction('confirmingTranslateEverything'),

	setPostTypes: setAction('postTypes'),

	setMethod: thunk(async (actions, method, {getState}) => {
		const isTranslateEverything = method === 'automatic';
		const currentMethod = getState().method;

		actions.updateMethod(method);

		const saveAutomaticMode = async () => {
			const {data: {data}} = await callEndpoint(endpoints.untranslatedCount, {})
			actions.setPostTypes(data)

			let hasOldContent = Object.values(data).reduce((accumulator, currentValue) => (accumulator + currentValue)) > 0;

			if(!hasOldContent) {
				actions.setSaving(true);
				await callEndpoint(endpoints.setTranslateEverything, {
					translateEverything: isTranslateEverything,
					method: method,
					onlyNew: true
				});
				actions.setSaving(false);
			}

			actions.setConfirming(hasOldContent);
		}

		const saveManualMode = async () => {
			actions.setSaving(true);
			await callEndpoint(endpoints.setTranslateEverything, {
				translateEverything: isTranslateEverything
			});
			actions.setSaving(false);
		};

		if (method !== currentMethod) {
			isTranslateEverything ? saveAutomaticMode() : await saveManualMode();
		}
	}),

	setReviewMode: thunk(async (actions, reviewMode) => {
		actions.updateReviewMode(reviewMode);
		await callEndpoint(endpoints.setTranslateEverything, {reviewMode});
	}),
});
