import SyncElementJobs from "./sync-translations-of-single-element/sync";
import SyncAndDownload from "./sync-translations-of-single-element/SyncAndDownload";
import JobsAPI from "../jobs/api/JobsAPI";
import Request from "../shared/Request";
import UIChanges from "./sync-translations-of-single-element/UIChanges";

import {createInstance} from "./pickup-translations/PickupTranslations";

document.addEventListener("DOMContentLoaded", () => {
	[...document.querySelectorAll(".wpml-sync-and-download-translation")].forEach(button => {
		new SyncElementJobs(
			button,
			document,
			() => new SyncAndDownload(new JobsAPI(new Request())),
			(document, button, icons) => new UIChanges(document, button, icons)
		);
	});

	const pickupWrap = document.querySelector('#wpml-tm-polling-wrap');
	if (pickupWrap) {
		createInstance(pickupWrap);
	}
});

