import React from 'react';
import ReactDOM from 'react-dom';
import {JobsProvider} from "./context/JobsProvider";
import {StringsProvider} from "./context/StringsProvider";
import ProcessController from "./context/ProcessController";
import Main from "./components/Main";

import JobsAPI from "../../jobs/api/JobsAPI";
import Request from "../../shared/Request";
import {JobsLoader} from "./model/JobsLoader";
import {create} from "./model/Process";

export const createInstance = (root) => {
	const request = new Request();
	const jobsAPI = new JobsAPI(request);

	const app = (
		<StringsProvider>
			<JobsProvider jobsLoader={new JobsLoader(jobsAPI)}>
				<ProcessController createProcess={create}>
					<Main/>
				</ProcessController>
			</JobsProvider>
		</StringsProvider>
	);

	ReactDOM.render(app, root);
};