/** gloabls WPML_TM_SETTINGS */

import React from 'react';
import moment from 'moment'
import {sprintf} from 'sprintf-js';
import connect from '../../../jobs/context/connect';
import {JobsConsumer} from "../context/JobsProvider";
import {StringsConsumer} from "../context/StringsProvider";
import {ProcessConsumer} from "../context/ProcessController";

export const DATE_FORMAT = 'YYYY-MM-DD HH:mm';

export class PollingBox extends React.Component {


	static shouldDisableTheButton(lastPickupDate) {
		if (WPML_TM_SETTINGS.debug || !lastPickupDate) {
			return false;
		}

		return lastPickupDate.isAfter(moment().utc().subtract(5, 'minutes'));
	}

	render() {
		const {jobs, strings, lastPickupDate, process} = this.props;

		const numText = jobs.length === 1 ?
			sprintf(strings.numberOfTranslationStringsSingle, 1) :
			sprintf(strings.numberOfTranslationStringsMulti, jobs.length);

		const fullText = jobs.length === 1 ?
			sprintf(strings.stringsSentToTranslationSingle, `<strong>${numText}</strong>`) :
			sprintf(strings.stringsSentToTranslationMulti, `<strong>${numText}</strong>`);

		return (
			<div className="wpml-tm-polling otgs-notice message">
				<p>
					<span id="wpml-tm-polling-jobs-number" dangerouslySetInnerHTML={{__html: fullText}}/>
					<input
						type="button"
						className="button button-secondary"
						value={strings.buttonText}
						onClick={() => process.run()}
						disabled={PollingBox.shouldDisableTheButton(lastPickupDate)}
					/>
					<span id="wpml-tmp-polling-last-pickup" className="wpml-tm-polling-last-pickup">
						{
							sprintf(
								strings.lastCheck,
								lastPickupDate ? lastPickupDate.local().format(DATE_FORMAT) : strings.never
							)
						}
					</span>
				</p>
			</div>
		);
	}

}

export default connect(PollingBox, StringsConsumer, JobsConsumer, ProcessConsumer);